/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class DiscretizeTest
extends AbstractFilterTest {
    public DiscretizeTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.setClassIndex(1);
    }

    @Override
    public Filter getFilter() {
        Discretize f = new Discretize();
        return f;
    }

    public Filter getFilter(String rangelist) {
        try {
            Discretize f = new Discretize();
            f.setAttributeIndices(rangelist);
            return f;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DiscretizeTest.fail("Exception setting attribute range: " + rangelist + "\n" + ex.getMessage());
            return null;
        }
    }

    public void testTypical() {
        this.m_Filter = this.getFilter("1,2");
        Instances result = this.useFilter();
        DiscretizeTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        int i = 0;
        while (i < result.numAttributes()) {
            DiscretizeTest.assertEquals(this.m_Instances.attribute(i).type(), result.attribute(i).type());
            DiscretizeTest.assertEquals(this.m_Instances.attribute(i).name(), result.attribute(i).name());
            ++i;
        }
    }

    public void testTypical2() {
        this.m_Filter = this.getFilter("3-4");
        Instances result = this.useFilter();
        DiscretizeTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        int i = 0;
        while (i < result.numAttributes()) {
            if (i != 2) {
                DiscretizeTest.assertEquals(this.m_Instances.attribute(i).type(), result.attribute(i).type());
                DiscretizeTest.assertEquals(this.m_Instances.attribute(i).name(), result.attribute(i).name());
            } else {
                DiscretizeTest.assertEquals(1, result.attribute(i).type());
                DiscretizeTest.assertEquals(1, result.attribute(i).numValues());
            }
            ++i;
        }
    }

    public void testInverted() {
        this.m_Filter = this.getFilter("1,2");
        ((Discretize)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        DiscretizeTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        int i = 0;
        while (i < result.numAttributes()) {
            if (i < 2 || !this.m_Instances.attribute(i).isNumeric()) {
                DiscretizeTest.assertEquals(this.m_Instances.attribute(i).type(), result.attribute(i).type());
                DiscretizeTest.assertEquals(this.m_Instances.attribute(i).name(), result.attribute(i).name());
            } else {
                DiscretizeTest.assertEquals(1, result.attribute(i).type());
                DiscretizeTest.assertEquals(1, result.attribute(i).numValues());
            }
            ++i;
        }
    }

    public void testNonInverted2() {
        this.m_Filter = this.getFilter("first-3");
        ((Discretize)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        DiscretizeTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        int i = 0;
        while (i < result.numAttributes()) {
            if (i < 3 || !this.m_Instances.attribute(i).isNumeric()) {
                DiscretizeTest.assertEquals(this.m_Instances.attribute(i).type(), result.attribute(i).type());
                DiscretizeTest.assertEquals(this.m_Instances.attribute(i).name(), result.attribute(i).name());
            } else {
                DiscretizeTest.assertEquals(1, result.attribute(i).type());
                DiscretizeTest.assertEquals(1, result.attribute(i).numValues());
            }
            ++i;
        }
    }

    public void testBetterEncoding() {
        this.m_Filter = this.getFilter("3");
        ((Discretize)this.m_Filter).setUseBetterEncoding(true);
        Instances result = this.useFilter();
        DiscretizeTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        DiscretizeTest.assertEquals(1, result.attribute(2).type());
    }

    public void testUseKononenko() {
        this.m_Filter = this.getFilter("3");
        ((Discretize)this.m_Filter).setUseKononenko(true);
        Instances result = this.useFilter();
        DiscretizeTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        DiscretizeTest.assertEquals(1, result.attribute(2).type());
    }

    public static Test suite() {
        return new TestSuite(DiscretizeTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(DiscretizeTest.suite());
    }
}

